/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class StormfishModel<T extends Stormfish>
extends EntityModel<T>
implements HeadphoneModel.Scaleable<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("stormfish"), "main");
    private final ModelPart head;
    private final ModelPart body_main;
    private final ModelPart body_back;
    private final ModelPart body_back_2;

    public StormfishModel(ModelPart part) {
        super(RenderType::entityCutout);
        this.head = part.getChild("head");
        this.body_main = part.getChild("body_main");
        this.body_back = part.getChild("body_back");
        this.body_back_2 = this.body_back.getChild("body_back_2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, -7.25f, -6.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.01f)).texOffs(40, -3).addBox(0.0f, -12.25f, -6.0f, 0.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(26, 15).addBox(-0.5f, -2.3f, -4.0f, 1.0f, 1.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)-0.1571f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(25, 21).addBox(-0.5f, -3.15f, -5.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r3", CubeListBuilder.create().texOffs(12, 14).addBox(-1.0f, 0.125f, -4.91f, 2.0f, 3.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-7.25f, (float)-6.165f, (float)1.0297f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = partDefinition.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -7.25f, -3.0f, 3.0f, 6.0f, 7.0f, new CubeDeformation(0.1f)).texOffs(20, 3).addBox(0.0f, -11.25f, -3.0f, 0.0f, 4.0f, 7.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(16, 0).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.5f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(16, 4).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.5f, (float)-2.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition body_back = partDefinition.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(0, 23).addBox(-1.0f, -2.5f, 0.0f, 2.0f, 5.0f, 4.0f, CubeDeformation.NONE).texOffs(40, 4).addBox(0.0f, -5.5f, 0.0f, 0.0f, 3.0f, 2.0f, CubeDeformation.NONE).texOffs(40, 9).addBox(0.0f, 2.5f, 1.0f, 0.0f, 3.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)19.5f, (float)4.0f));
        body_back.addOrReplaceChild("body_back_2", CubeListBuilder.create().texOffs(13, 23).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 3.0f, CubeDeformation.NONE).texOffs(32, -4).addBox(0.0f, -4.5f, 3.0f, 0.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        if (!entity.isInWater() && !((AbstractThievesFish)entity).isNoFlip()) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
        }
        this.body_back.yRot = -backRotation * 0.2f * Mth.sin((float)(backRotSpeed * 0.65f * ageInTicks));
        this.body_back_2.yRot = -backRotation * 0.25f * Mth.sin((float)(backRotSpeed * 0.65f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
        this.body_main.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
        this.body_back.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
    }

    @Override
    public void scale(T entity, PoseStack poseStack) {
        float scale = 2.0f;
        poseStack.scale(scale - 0.5f, scale, scale - 0.5f);
        poseStack.translate(0.0f, -0.5f, -0.2f);
    }
}

